<?php

namespace app\index\controller;

use think\Controller;
use think\Db;
use think\Exception;
use think\exception\PDOException;
/**
 * 我的
 */
class User extends Common
{
    //个人中心
    public function index(){
        $user = db('user')->where(['id'=>session('user_id')])->find();
        $this->assign([
            'user' => $user,
        ]);
        return $this->fetch();
    }

    //分享二维码
    public function share(){
        $user = db('user')->where(['id'=>session('user_id')])->field('id,nickName')->find();
        $this->assign([
            'user' => $user,
        ]);
        return $this->fetch();
    }

    //游戏记录
    public function game_record(){
        if(request()->isPost()){
            $page = request()->post('page') ? request()->post('page') : 1;
            $limit = request()->post('limit') ? request()->post('limit') : 10;
            $date = request()->post('date') ? request()->post('date') : 0;
            $type = request()->post('type') ? request()->post('type') : 0;
            $where = [];
            $where['hl.u_id'] = session('user_id');
            if($type){
                $where['hb.playId'] = $type;
            }
            if($date){
                $where['hb.createTime'] = ['between',[strtotime($date.' 00:00:00'),strtotime($date.' 23:59:59')]];
            }
            $list   = db('hongbao_log')
                        ->alias('hl')
                        ->join('hongbao hb','hl.redPacketId=hb.id','left')
                        ->join('plays p','hb.playId=p.id','left')
                        ->join('groups g','hb.groupId=g.id','left')
                        ->where($where)
                        ->order('hl.id desc')
                        ->field('hl.*,hb.playId,p.name as pname,g.name as gname')
                        ->paginate(['list_rows' => $limit, 'page' => $page])
                        ->toArray();
            if($list['data']){
                foreach($list['data'] as $k=>$v){
                    $list['data'][$k]['joinTime'] = date('Y-m-d H:i:s',$v['joinTime']);
                }
            }
            return json(['code'=>1,'msg'=>'请求成功','data'=>$list]);
        }
        $date = get_date_data();
        $plays = db('plays')->limit(4)->field('id,name')->select();
        $this->assign([
            'date'  => $date,
            'plays' => $plays,
        ]);
        return $this->fetch();
    }

    public function logs_detail(){
        if(request()->isPost()){
            $id = request()->post('id');
            $log = db('hongbao_log')->where(['id'=>$id,'u_id'=>session('user_id')])->find();
            if(!$log){
                return json(['code'=>0,'msg'=>'数据不存在']);
            } 
            $hb = db('hongbao')->where(['id'=>$log['redPacketId']])->find();
            if(!$hb){
                return json(['code'=>0,'msg'=>'数据不存在']);
            }
            $hb['createTime'] = date('Y-m-d H:i:s',$hb['createTime']);
            $hb['md5Id'] = md5($hb['id']);
            $xian = $log['isBanker'] == 1 ? '庄':'闲';
            $gname = $hb['groupId'] ? db('groups')->where(['id'=>$hb['groupId']])->value('name') : '每日福利';
            $pname = $hb['playId'] ? db('plays')->where(['id'=>$hb['playId']])->value('name'):'福利红包';
            $hb['title'] =  $gname.'-'.$pname.'-'.$xian;
            $hb_logs = db('hongbao_log')->alias('hl')->join('user u','hl.u_id=u.id','left')->where(['hl.redPacketId'=>$hb['id']])->order('id asc')->field('hl.*,u.nickName')->select();
            if($hb_logs){
                $data = [
                    'hb'    => $hb,
                    'logs'  => $hb_logs,
                ];
                return json(['code'=>1,'msg'=>'success','data'=>$data]);
            }else{
                return json(['code'=>0,'msg'=>'数据不存在']);
            }
        }
    }

    //充值
    public function recharge(){
        if(request()->isPost()){
            //生成充值订单
            $payitem = request()->param('payitemsId');
            $data = [
                'u_id'  => session('user_id'),
                'order_num' => date('YmdHis').\fast\Random::numeric(6),
                'jine'  => db('payitems')->where(['id'=>$payitem])->value('jine'),
                'is_pay' => 0,
                'createtime' => time(),
                'updatetime' => time(),
            ];
            $res = db('order')->insertGetId($data);
            if($res){
                return json(['code'=>1,'msg'=>'订单提交成功，即将前往支付','data'=>['url'=>request()->domain().url('pay/mianqian').'?id='.$res]]);
            }else{
                return json(['code'=>0,'msg'=>'系统繁忙，请稍候重试']);
            }
        }
        $list = db('payitems')->order('jine asc')->select();
        $balance = db('user')->where(['id'=>session('user_id')])->value('balance');
        $this->assign([
            'list'      =>$list,
            'balance'   => $balance,
        ]);
        return $this->fetch();
    }

    //提现
    public function withdraw(){
        if(request()->isPost()){
            $jine = request()->post('jine');
            $zh = request()->post('zh');
            $password = request()->post('password');
            $user = db('user')->where(['id'=>session('user_id')])->find();
            if(md5($password) != $user['payPassword']){
                return json(['code'=>0,'msg'=>'支付密码错误']);
            }
            if($jine <= 0){
                return json(['code'=>0,'msg'=>'提现金额错误']);
            }
            $site = \think\Config::get('site');
            if($zh == 1){
                if($user['balance'] < $jine){
                    return json(['code'=>0,'msg'=>'当前账户余额不足']);
                }
                $withdrawRate = $site['withdrawRate'] ? $site['withdrawRate'] : 0;
            }
            if($zh == 2){
                if($user['agency'] < $jine){
                    return json(['code'=>0,'msg'=>'当前账户余额不足']);
                }
                $withdrawRate = $site['agencyWithdrawRate'] ? $site['agencyWithdrawRate'] : 0;
            }
            Db::startTrans();
            try {
                jine_log($user['id'],4,-$jine,$zh == 1 ?'【提现】普通账户提现'.sprintf('%.2f',$jine).'金币': '【提现】代理账户提现'.sprintf('%.2f',$jine).'金币',$pay_uid=0, $zh == 1 ? 0 : 1);
                $data = [
                    'u_id'  => $user['id'],
                    'jine'  => $jine,
                    'status'    => 0,
                    'openid'    => $user['withdrawOpenId'],
                    'shiji_jine' => $jine * (1 - $withdrawRate),
                    'createtime'    => time(),
                    'updatetime'    => time(),
                    'tx_zh'     => $zh ? $zh : 1,
                ];
                $res = db('tixian')->insertGetId($data);
                Db::commit();
                return json(['code'=>1,'msg'=>'提现成功']);
            } catch (PDOException $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'提现失败']);
            } catch (Exception $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'提现失败']); // $e->getMessage();
            }
        }
        $user = db('user')->where(['id'=>session('user_id')])->find();
        if($user['phone'] == '' || $user['payPassword'] == ''){
            return $this->redirect('user/wallet');
        }
        $site = \think\Config::get('site');
        $withdraw = [
            'withdrawAutoPrice'     => $site['withdrawAutoPrice'],//自动提现金额
            'withdrawMax'           => $site['withdrawMax'],//最大提现金额
            'withdrawMin'           => $site['withdrawMin'],//最小提现金额
            'withdrawNum'           => $site['withdrawNum'],//每日可提现次数
            'withdrawRate'          => $site['withdrawRate'],//普通账户提现手续费
            'agencyWithdrawRate'    => $site['agencyWithdrawRate'],//代理账户提现手续费
        ];
        $this->assign([
            'user'      => $user,
            'withdraw'  => $withdraw,
        ]);
        return $this->fetch();
    }
    //代理提现
    public function withdrawagent(){
        if(request()->isPost()){
            $jine = request()->post('jine');
            $zh = request()->post('zh');
            $password = request()->post('password');
            $user = db('user')->where(['id'=>session('user_id')])->find();
            if(md5($password) != $user['payPassword']){
                return json(['code'=>0,'msg'=>'支付密码错误']);
            }
            if($jine <= 0){
                return json(['code'=>0,'msg'=>'提现金额错误']);
            }
            $site = \think\Config::get('site');
            if($zh == 1){
                if($user['balance'] < $jine){
                    return json(['code'=>0,'msg'=>'当前账户余额不足']);
                }
                $withdrawRate = $site['withdrawRate'] ? $site['withdrawRate'] : 0;
            }
            if($zh == 2){
                if($user['agency'] < $jine){
                    return json(['code'=>0,'msg'=>'当前账户余额不足']);
                }
                $withdrawRate = $site['agencyWithdrawRate'] ? $site['agencyWithdrawRate'] : 0;
            }
            Db::startTrans();
            try {
                jine_log($user['id'],4,-$jine,$zh == 1 ?'【提现】普通账户提现'.sprintf('%.2f',$jine).'金币': '【提现】代理账户提现'.sprintf('%.2f',$jine).'金币',$pay_uid=0, $zh == 1 ? 0 : 1);
                $data = [
                    'u_id'  => $user['id'],
                    'jine'  => $jine,
                    'status'    => 0,
                    'openid'    => $user['withdrawOpenId'],
                    'shiji_jine' => $jine * (1 - $withdrawRate),
                    'createtime'    => time(),
                    'updatetime'    => time(),
                    'tx_zh'     => $zh ? $zh : 1,
                ];
                $res = db('tixian')->insertGetId($data);
                Db::commit();
                return json(['code'=>1,'msg'=>'提现成功']);
            } catch (PDOException $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'提现失败']);
            } catch (Exception $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'提现失败']); // $e->getMessage();
            }
        }
        $user = db('user')->where(['id'=>session('user_id')])->find();
        if($user['phone'] == '' || $user['payPassword'] == ''){
            return $this->redirect('user/wallet');
        }
        if($user['isAgent'] == 0){
            return $this->redirect('user/withdraw');
        }
        $site = \think\Config::get('site');
        $withdraw = [
            'withdrawAutoPrice'     => $site['withdrawAutoPrice'],//自动提现金额
            'withdrawMax'           => $site['withdrawMax'],//最大提现金额
            'withdrawMin'           => $site['withdrawMin'],//最小提现金额
            'withdrawNum'           => $site['withdrawNum'],//每日可提现次数
            'withdrawRate'          => $site['withdrawRate'],//普通账户提现手续费
            'agencyWithdrawRate'    => $site['agencyWithdrawRate'],//代理账户提现手续费
        ];
        $this->assign([
            'user'      => $user,
            'withdraw'  => $withdraw,
        ]);
        return $this->fetch();
    }

    //支付
    public function wallet(){
        $user = db('user')->where(['id'=>session('user_id')])->find();
        $this->assign([
            'user'      => $user,
        ]);
        return $this->fetch();
    }

    //帮助中心
    public function help(){
        $list = db('help')->order('id asc')->select();
        $this->assign('list',$list);
        return $this->fetch();
    }

    //投诉
    public function wain(){

        return $this->fetch();
    }

    //投诉子页面
    public function child(){
        
        return $this->fetch();
    }

    //投诉成功
    public function success_page(){
        return $this->fetch();
    }

    //转账给玩家
    public function transfer(){
        if(request()->isPost()){
            $uid = request()->post('uid');
            if($uid == session('user_id')){
                return json(['code'=>0,'msg'=>'不能转账给自己','type'=>'normal']);
            }
            $my = db('user')->where(['id'=>session('user_id')])->field('id,nickName,balance,payPassword,phone')->find();
            if($my['phone'] == ''){
                return json(['code'=>0,'msg'=>'请先实名认证','type'=>'auth']);
            }
            if($my['payPassword'] == ''){
                return json(['code'=>0,'msg'=>'请先设置支付密码','type'=>'set']);
            }
            $jine = request()->post('jine');
            if($jine <= 0){
                return json(['code'=>0,'msg'=>'金额不正确','type'=>'normal']);
            }
            $password = request()->post('password');
            $user = db('user')->where(['id'=>$uid])->find();
            if(!$user){
                return json(['code'=>0,'msg'=>'用户不存在','type'=>'normal']);
            }
            if($my['balance'] < $jine){
                return json(['code'=>0,'msg'=>'当前账户余额不足','type'=>'normal']);
            }
            if(md5($password) != $my['payPassword']){
                return json(['code'=>0,'msg'=>'支付密码错误','type'=>'normal']);
            }
            //类型:1=收红包,2=发红包,3=充值,4=提现,5=推广,6=赢,7=输,8=收福利,9=发福利,10=退还,11=流水佣金,12=输赢分红,13=领钱转出,14=领钱转入
            Db::startTrans();
            try {
                jine_log($uid, 14, $jine, '【领钱转入】玩家“'.$my['nickName'].'”向您转账'.sprintf('%.2f',$jine).'元', $my['id']);
                jine_log($my['id'], 13, -$jine, '【领钱转出】您向玩家“'.$user['nickName'].'”转账'.sprintf('%.2f',$jine).'元', $pay_uid = 0);
                Db::commit();
                return json(['code'=>1,'msg'=>'转账成功']);
            } catch (PDOException $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'转账失败','type'=>'normal']);
            } catch (Exception $e) {
                Db::rollback();
                return json(['code'=>0,'msg'=>'转账失败','type'=>'normal']); // $e->getMessage();
            }
        }
        $user = db('user')->where(['id'=>session('user_id')])->find();
        $this->assign([
            'user'      => $user,
        ]);
        return $this->fetch();
    }

    //账单
    public function record(){
        if(request()->isPost()){
            $page = request()->post('page') ? request()->post('page') : 1;
            $limit = request()->post('limit') ? request()->post('limit') : 10;
            $date = request()->post('date') ? request()->post('date') : 0;
            $type = request()->post('type') ? request()->post('type') : 0;
            $where = [];
            $where['u_id'] = session('user_id');
            if($type){
                $where['type'] = $type;
            }
            if($date){
                $where['createTime'] = ['between',[strtotime($date.' 00:00:00'),strtotime($date.' 23:59:59')]];
            }
            $list   = db('jine_log')
                        ->where($where)
                        ->order('createTime desc')
                        ->paginate(['list_rows' => $limit, 'page' => $page])
                        ->toArray();
            if($list['data']){
                foreach($list['data'] as $k=>$v){
                    $list['data'][$k]['createTime'] = date('Y-m-d H:i:s',$v['createTime']);
                    $list['data'][$k]['type_str'] = gettypestr($v['type']);
                }
            }
            return json(['code'=>1,'msg'=>'请求成功','data'=>$list]);
        }
        $date = get_date_data();
        $this->assign([
            'date'  => $date,
        ]);
        return $this->fetch();
    }

    public function jinelog_detail(){
        if(request()->isPost()){
            $id = request()->post('id');
            $log = db('jine_log')->where(['id'=>$id,'u_id'=>session('user_id')])->find();
            $log['type_str'] = gettypestr($log['type']);
            $log['createTime'] = date('Y-m-d H:i:s',$log['createTime']);
            $log['md5Id'] = md5($log['id']);
            if(!$log){
                return json(['code'=>0,'msg'=>'记录不存在']);
            }else{
                return json(['code'=>1,'msg'=>'success','data'=>$log]);
            }
        }
    }

    //我的团队
    public function team(){
        $user = db('user')->where(['id'=>session('user_id')])->find();
        if($user['isAgent'] == 0){
            return $this->redirect('user/index');
        }
        $today_insert = db('user')->where(['p_id|p_id2|p_id3'=>$user['id']])->whereTime('createTime','today')->count();
        $all_xiaji_ids = db('user')->where(['p_id|p_id2|p_id3'=>$user['id']])->column('id');
        $today_active = db('jine_log')->alias('j')->join('user u','j.u_id=u.id','left')->where(['j.type'=>['in',['1','2','3','6','7','8','9']],'u.id'=>['in',$all_xiaji_ids]])->whereTime('j.createTime','today')->group('j.u_id')->count();
        $all_xiaji = count($all_xiaji_ids);
        $this->assign([
            'user'=>$user,
            'today_insert'  => $today_insert,
            'today_active'  => $today_active,
            'all_xiaji'     => $all_xiaji,
        ]);
        return $this->fetch();
    }

    //我的玩家
    public function friend(){
        if(request()->isPost()){
            $page = request()->post('page') ? request()->post('page') : 1;
            $limit = request()->post('limit') ? request()->post('limit') : 10;
            $type = request()->post('type') ? request()->post('type') : 0;
            $uid = request()->post('uid') ? request()->post('uid') : 0;
            $where = [];
            $where['p_id|p_id2|p_id3'] = session('user_id');
            if($uid){
                $where['id'] = $uid;
            }
            if($type == 1){
                $where['isAgent'] = '1';
            }elseif($type == 2){
                $where['isAgent'] = '0';
            }
            $list = db('user')->where($where)->order('id desc')->field('id,nickName,headimgUrl,isAgent')->paginate(['list_rows' => $limit, 'page' => $page])->toArray();
            if($list['data']){
                foreach($list['data'] as $k=>$v){
                    $list['data'][$k]['week_num'] = db('user')->where(['p_id|p_id2|p_id3'=>$v['id']])->whereTime('createTime','week')->count();
                    //1=收红包,2=发红包,3=充值,4=提现,5=推广,6=赢,7=输,8=收福利,9=发福利,10=退还,11=流水佣金,12=输赢分红,13=领钱转出,14=领钱转入
                    $jine = db('jine_log')->where(['u_id'=>$v['id'],'type'=>['in',['6','7']]])->whereTime('createTime','yesterday')->sum('price');
                    $list['data'][$k]['yesterday_jine']  = $jine ? sprintf('%.2f',$jine) : '0.00';
                }
            }
            return json(['code'=>1,'msg'=>'请求成功','data'=>$list]);
        }
        $yesterday = date('Y-m-d',strtotime('-1 day'));
        $this->assign('yesterday',$yesterday);
        return $this->fetch();
    }

    //玩家比例详情
    public function daili_set_info(){
        if(request()->isPost()){
            $id = request()->post('id');
            $user = db('user')->where(['id'=>$id,'p_id|p_id2|p_id3'=>session('user_id')])->field('id,group_bili,home_bili')->find();
            if($user){
                return json(['code'=>1,'msg'=>'success','data'=>$user]);
            }else{
                return json(['code'=>0,'msg'=>'error']);
            }
        }
    }

    //我的业绩
    public function profit(){
        if(request()->isPost()){
            $page = request()->post('page') ? request()->post('page') : 1;
            $limit = request()->post('limit') ? request()->post('limit') : 10;
            $today_w = date('w');
            if($today_w == 1){
                //查上周
                $list = db('profit')->where(['u_id'=>session('user_id')])->whereTime('createtime','last week')->order('createtime desc')->paginate(['list_rows' => $limit, 'page' => $page])->toArray();
            }else{
                //查本周
                $list = db('profit')->where(['u_id'=>session('user_id')])->whereTime('createtime','week')->order('createtime desc')->paginate(['list_rows' => $limit, 'page' => $page])->toArray();
            }
            return json(['code'=>1,'msg'=>'请求成功','data'=>$list]);
        }
        $user = db('user')->where(['id'=>session('user_id')])->find();
        if($user['isAgent'] == '0'){
            return $this->redirect('user/index');
        }
        check_profit(session('user_id'));
        return $this->fetch();
    }

    //下级详情
    public function xiaji_detail(){
        if(request()->isPost()){
            $id = request()->post('id');
            $user = db('user')->where(['id'=>$id,'p_id|p_id2|p_id3'=>session('user_id')])->find();
            $user['group_bili'] = $user['group_bili'] ? $user['group_bili'] : 50;
            $user['home_bili'] = $user['home_bili'] ? $user['home_bili'] : 2;
            $group_liushui = db('jine_log')->where(['u_id'=>$id,'type'=>'2'])->whereTime('createTime','yesterday')->sum('price');
            $user['group_liushui'] = sprintf('%.2f',$group_liushui);
            $group_yongjin = $user['group_liushui'] * ($user['group_bili'] /10000);
            $user['group_yongjin'] = sprintf('%.2f',$group_yongjin);
            $yesterday_shu = db('jine_log')->where(['u_id'=>$id,'type'=>'7'])->whereTime('createTime','yesterday')->sum('price');
            $yesterday_ying = db('jine_log')->where(['u_id'=>$id,'type'=>'6'])->whereTime('createTime','yesterday')->sum('price');
            $user['group_gongxian'] = sprintf('%.2f',(abs($yesterday_shu) - abs($yesterday_ying)));

            $user['home_shuying'] = sprintf('%.2f',(abs($yesterday_shu) - abs($yesterday_ying)));
            $user['shuying_fenhong'] = (abs($yesterday_shu) - abs($yesterday_ying)) * ($user['home_bili'] /100);
            $user['shuying_gongxian'] = sprintf('%.2f',(abs($yesterday_shu) - abs($yesterday_ying)));

            $user['yesterday_all_gongxian'] = sprintf('%.2f',(abs($yesterday_shu) - abs($yesterday_ying)));

            $week_ziji_shu = db('jine_log')->where(['u_id'=>$id,'type'=>'7'])->whereTime('createTime','week')->sum('price');
            $week_ziji_ying = db('jine_log')->where(['u_id'=>$id,'type'=>'6'])->whereTime('createTime','week')->sum('price');
            $user['week_ziji_gongxian'] = sprintf('%.2f',(abs($week_ziji_shu) - abs($week_ziji_ying)));
            $xiajiIds = db('user')->where(['p_id|p_id2|p_id3'=>$id])->column('id');
            $week_xiaji_shu = db('jine_log')->where(['u_id'=>['in',$xiajiIds],'type'=>'7'])->whereTime('createTime','week')->sum('price');
            $week_xiaji_ying = db('jine_log')->where(['u_id'=>['in',$xiajiIds],'type'=>'6'])->whereTime('createTime','week')->sum('price');
            $user['week_xiaji_gongxian'] = sprintf('%.2f',(abs($week_xiaji_shu) - abs($week_xiaji_ying)));

            $user['week_new_user_count'] = db('user')->where(['p_id|p_id2|p_id3'=>$id])->whereTime('createTime','week')->count();
            $user['all_user_count'] = db('user')->where(['p_id|p_id2|p_id3'=>$id])->count();

            $all_shu = db('jine_log')->where(['u_id'=>$id,'type'=>'7'])->sum('price');
            $all_ying = db('jine_log')->where(['u_id'=>$id,'type'=>'6'])->sum('price');
            $user['all_gongxian'] = sprintf('%.2f',(abs($all_shu) - abs($all_ying)));
            if($user){
                return json(['code'=>1,'msg'=>'请求成功','data'=>$user]);
            }else{
                return json(['code'=>0]);
            }
        }
    }

    //修改下级比例
    public function updatebili(){
        if(request()->isPost()){
            $id = request()->post('id');
            $user = db('user')->where(['id'=>$id,'p_id|p_id2|p_id3'=>session('user_id')])->find();
            $group_bili = request()->post('group_bili');
            $home_bili = request()->post('home_bili');

            if($user['group_bili'] > $group_bili){
                return json(['code'=>0,'msg'=>'下级流水业绩配额不可小于原先配置']);
            }
            if($user['home_bili'] > $home_bili){
                return json(['code'=>0,'msg'=>'下级流水业绩配额不可小于原先配置']);
            }
            $user = db('user')->where(['id'=>$id,'p_id|p_id2|p_id3'=>session('user_id')])->update(['group_bili'=>$group_bili,'home_bili'=>$home_bili,'isAgent'=>1,'updateTime'=>time()]);
            if($user){
                return json(['code'=>1,'msg'=>'请求成功']);
            }else{
                return json(['code'=>0]);
            }
        }
    }

    //在线客服
    public function kefu(){
        $site = \think\Config::get('site');
        $kefu_qrcode = $site['kefu_qrcode'];
        $this->assign([
            'kefu_qrcode'   => $kefu_qrcode,
        ]);
        return $this->fetch();
    }

    //奖励说明
    public function word(){
        $site = \think\Config::get('site');
        $prize_desc = $site['prize_desc'];
        $this->assign([
            'prize_desc'   => $prize_desc,
        ]);
        return $this->fetch();
    }

    //分享二维码
    public function qrcode(){
        $site = \think\Config::get("site");
        $url = $site['fangfeng_url'];
        if($url){
            $value = $url.'?p_id='.session('user_id'); //二维码内容 
        }else{
            $value = request()->domain().url('login/login').'?p_id='.session('user_id'); //二维码内容 
        }
        //生成二维码图片 
        \think\Loader::import('qrcode.qrcode');
        return \QRcode::png($value,false, 'L', 3,3, false); 
    }

    //实名认证
    public function forget(){

        return $this->fetch();
    }

    //设置密码
    public function paypassword(){
        if(request()->isPost()){
            $user = db('user')->where(['id'=>session('user_id')])->find();
            if($user['payPassword'] != ''){
                return json(['code'=>0,'msg'=>'您已设置过支付密码，请勿重新设置']);
            }
            $data1 = request()->post('data1');
            $data2 = request()->post('data2');
            if($data1 != $data2){
                return json(['code'=>0,'msg'=>'两次密码不一致']);
            }
            $update = db('user')->where(['id'=>session('user_id')])->update(['isWithdrawPasswordSet'=>'1','payPassword'=>md5($data1)]);
            if($update){
                return json(['code'=>1,'msg'=>'设置成功']);
            }else{
                return json(['code'=>0,'msg'=>'设置失败']);
            }
        }
        return $this->fetch();
    }

    //修改密码
    public function updatepassword(){
        if(request()->isPost()){
            $user = db('user')->where(['id'=>session('user_id')])->find();
            $data1 = request()->post('data1');
            $data2 = request()->post('data2');
            $data3 = request()->post('data3');
            if(md5($data1) != $user['payPassword']){
                return json(['code'=>0,'msg'=>'旧支付密码错误']);
            }
            if($data2 != $data3){
                return json(['code'=>0,'msg'=>'两次密码不一致']);
            }
            $update = db('user')->where(['id'=>session('user_id')])->update(['payPassword'=>md5($data2),'updateTime'=>time()]);
            if($update){
                return json(['code'=>1,'msg'=>'修改成功']);
            }else{
                return json(['code'=>0,'msg'=>'修改失败']);
            }
        }
        return $this->fetch();
    }

    //忘记密码
    public function forgetsetmima(){
        if(request()->isPost()){
            $user = db('user')->where(['id'=>session('user_id')])->find();
            if($user['payPassword'] == ''){
                return json(['code'=>0,'msg'=>'您还未设置过支付密码']);
            }
            $data1 = request()->post('data1');
            $data2 = request()->post('data2');
            if($data1 != $data2){
                return json(['code'=>0,'msg'=>'两次密码不一致']);
            }
            $update = db('user')->where(['id'=>session('user_id')])->update(['isWithdrawPasswordSet'=>'1','payPassword'=>md5($data1),'updateTime'=>time()]);
            if($update){
                return json(['code'=>1,'msg'=>'设置成功']);
            }else{
                return json(['code'=>0,'msg'=>'设置失败']);
            }
        }
        return $this->fetch();
    }

    //忘记密码
    public function forgetmima(){
        return $this->fetch();
    }

}